<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Resource extends Model 
{

    protected $table = 'resources';
    public $timestamps = true;

    public function users()
    {
        return $this->belongsToMany('App\User')->withPivot('type');
    }

    public function section()
    {
        return $this->belongsTo('App\Models\Section');
    }

    public function sourceDetails()
    {
        return $this->hasMany('App\Models\SourceDetail');
    }

    public function sourceFields()
    {
        return $this->hasMany('App\Models\SourceField');
    }

}